/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.client;

import com.ibm.hsc.client.CDThreadPool;
import java.util.Vector;

public abstract class CDWorkerThread
extends Thread {
    protected String _Name;
    protected String[] _cmdArgs;
    protected boolean _initialized = false;
    protected boolean _available;
    protected Vector _returnData;
    protected boolean _done;
    protected CDThreadPool _tPool;
    protected int _nCmdsServiced;

    public CDWorkerThread(ThreadGroup threadGroup, String string, Vector vector, CDThreadPool cDThreadPool) {
        super(threadGroup, string);
        this._Name = string;
        this._cmdArgs = null;
        this._available = false;
        this._returnData = vector;
        this._tPool = cDThreadPool;
        this._done = false;
        this._nCmdsServiced = 0;
    }

    public String[] getCmdArgs() {
        return this._cmdArgs;
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public boolean isAvailable() {
        return this._available;
    }

    public void setAvailable(boolean bl) {
        this._available = bl;
    }

    public abstract void doCmd(String[] var1);

    private void debug(String string) {
        System.err.println("| WorkerThread." + string);
    }

    public synchronized void routeRequest(String[] stringArray) {
        this.setAvailable(false);
        this.debug("Setting available for " + this.getName() + " = false, request=" + stringArray[0]);
        this._cmdArgs = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this._cmdArgs, 0, stringArray.length);
        try {
            this.debug(this.getName() + " calling notify...");
            this.notify();
            this.debug(this.getName() + " BACK FROM calling notify...");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private synchronized void waitForRequest() {
        try {
            this.debug(this.getName() + " calling wait...");
            this.wait();
            this.debug(this.getName() + " BACK FROM calling wait...");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setDone(boolean bl) {
        this._done = bl;
    }

    private void cleanup() {
    }

    public int getNServiced() {
        return this._nCmdsServiced;
    }

    public void run() {
        this.debug(this.getName() + " starting...");
        boolean bl = false;
        while (!this._done) {
            if (!bl) {
                this.debug(this.getName() + "  waiting for request...");
                this.debug("Setting available for " + this.getName() + " = true");
                this.setAvailable(true);
                this._initialized = true;
                while (!this._done && this._cmdArgs == null) {
                    this.waitForRequest();
                }
                if (this._cmdArgs != null) {
                    this.debug(this.getName() + ": Got NEW request: " + this._cmdArgs[0]);
                } else {
                    this.debug(this.getName() + ": Woke up, done = " + this._done);
                }
            }
            if (this._done) {
                this.cleanup();
                break;
            }
            try {
                this.doCmd(this._cmdArgs);
                this._cmdArgs = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this.debug(this.getName() + " checking for queued request...");
            this._cmdArgs = this._tPool.getQueuedRequest();
            if (this._cmdArgs != null) {
                this.debug(this.getName() + ":      Got QUEUED request: " + this._cmdArgs[0]);
                bl = true;
                continue;
            }
            bl = false;
        }
        this.debug(this.getName() + " is exiting...");
    }
}

